function ok = uwierzytelnij(pesel)

    if isnumeric(pesel)
        pesel = num2str(pesel);
    end
    peselStr = string(pesel);

    if strlength(peselStr) ~= 11 || ~all(isstrprop(char(peselStr),'digit'))
        disp("Niepoprawny pesel");
        ok = 0;
        return;
    end

    cyfry = double(char(peselStr)) - '0';

    wagi = [1 3 7 9 1 3 7 9 1 3];
    suma = sum(wagi .* cyfry(1:10));
    k = mod(10 - mod(suma, 10), 10);

    if k ~= cyfry(11)
        disp("Niepoprawny pesel");
        ok = 0;
        return;
    end

    ok = 1;

    if mod(cyfry(10), 2) == 0
        disp("Podała Pani prawidłowy numer pesel");
    else
        disp("Podał Pan prawidłowy numer pesel");
    end
end
