x1 = linspace(-5, 5, 1000);
x2 = linspace(0.05, 5, 1000);
x3 = linspace(-2, 2, 1000);

y1 = x1.^2;
y2 = log(x2);
y3 = exp(x3);

figure;
plot(x1,y1,'b-','LineWidth',1.5);
grid on;
xlabel('x');
ylabel('y');
title('y = x^2');

figure;
plot(x2,y2,'r--','LineWidth',1.5);
grid on;
xlabel('x');
ylabel('y');
title('y = log(x)');

figure; plot(x3,y3,'g:','LineWidth',1.5);
grid on;
xlabel('x');
ylabel('y');
title('y = e^x');

x = linspace(0.05, 5, 1000);
figure('Name','Razem');
plot(x, x.^2, 'b-', x, log(x), 'r--', x, exp(x), 'g:', 'LineWidth',1.5);
grid on;
xlabel('x');
ylabel('y');
title('y = x^2, y = log(x), y = e^x (na jednym wykresie)');
legend('x^2','log(x)','e^x','Location','northwest');

figure('Name','Subplot');
subplot(1,3,1);
plot(x1,y1,'b-','LineWidth',1.5); grid on;
title('y = x^2');
xlabel('x');
ylabel('y');

subplot(1,3,2);
plot(x2,y2,'r--','LineWidth',1.5); grid on;
title('y = log(x)');
xlabel('x');
ylabel('y');

subplot(1,3,3);
plot(x3,y3,'g:','LineWidth',1.5);
grid on;
title('y = e^x');
xlabel('x');
ylabel('y');
